/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util.biome;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import me.pepperbell.continuity.client.util.biome.BiomeHolder;
import me.pepperbell.continuity.client.util.biome.BiomeHolderManager;
import net.minecraft.world.level.biome.Biome;

public class BiomeSetPredicate
implements Predicate<Biome> {
    private final Set<BiomeHolder> holders;
    private Set<Biome> biomes = Collections.emptySet();

    public BiomeSetPredicate(Set<BiomeHolder> holders) {
        this.holders = holders;
        BiomeHolderManager.addRefreshCallback(this::refresh);
    }

    @Override
    public boolean test(Biome biome) {
        return this.biomes.contains(biome);
    }

    private void refresh() {
        ObjectOpenHashSet biomes = new ObjectOpenHashSet(16, 0.5f);
        for (BiomeHolder holder : this.holders) {
            Biome biome = holder.getBiome();
            if (biome == null) continue;
            biomes.add(biome);
        }
        this.biomes = biomes;
    }
}

